/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.mother_silverfish.event;

import com.hollingsworth.mother_silverfish.event.ITimedEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mother_silverfish")
public class EventQueue {
    List<ITimedEvent> events = new ArrayList<ITimedEvent>();
    private static EventQueue serverQueue;
    private static EventQueue clientQueue;

    public void tick(boolean serverSide) {
        if (this.events == null || this.events.isEmpty()) {
            return;
        }
        ArrayList<ITimedEvent> stale = new ArrayList<ITimedEvent>();
        for (int i = 0; i < this.events.size(); ++i) {
            ITimedEvent event = this.events.get(i);
            if (event.isExpired()) {
                stale.add(event);
                continue;
            }
            event.tick(serverSide);
        }
        this.events.removeAll(stale);
    }

    public void addEvent(ITimedEvent event) {
        if (this.events == null) {
            this.events = new ArrayList<ITimedEvent>();
        }
        this.events.add(event);
    }

    public static EventQueue getServerInstance() {
        if (serverQueue == null) {
            serverQueue = new EventQueue();
        }
        return serverQueue;
    }

    public static EventQueue getClientQueue() {
        if (clientQueue == null) {
            clientQueue = new EventQueue();
        }
        return clientQueue;
    }

    public void clear() {
        this.events = null;
    }

    private EventQueue() {
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        EventQueue.getServerInstance().tick(true);
    }

    @SubscribeEvent
    public static void clientTickEvent(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        EventQueue.getClientQueue().tick(false);
    }
}

